/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class ParticleSystem {
    public static final byte PS_TYPE_NONE = 0;
    public static final byte PS_TYPE_DISPERSE = 1;
    public static final byte PS_TYPE_BLIZZARD = 3;
    public static final byte PS_TYPE_SNOW = 4;
    public static final byte PS_TYPE_SPRAY = 5;
    public static final byte PS_TYPE_4DIRSPRAY = 6;
    public static final byte PS_TYPE_RING = 7;
    public static final byte PS_TYPE_BOMB = 8;
    protected byte type = 0;
    public String name;
    public Vector particleList = new Vector();
    public long time = 0L;
    public long lastTime = 0L;
    public int limit = 100;
    public int minSpeed = 30;
    public int maxSpeed = 30;
    public int attenuation = 0;
    public int minSize = 30;
    public int maxSize = 30;
    public Random rand = new Random();
    public int x = 0;
    public int y = 0;
    public int z = 0;
    public boolean visiable = true;
    public boolean finished = false;
    public int length;
    public int width;
    public int height;
    public int createNumber = 1024;
    public int createTime = 30;
    public int textureWidth = 1;
    public int textureHeight = 1;
    public int blockWidth = 16;
    public int blockHeight = 16;
    public int direct4 = 0;
    public static final byte PS_FACEDIRECT_DEFAULT = 0;
    public static final byte PS_FACEDIRECT_VERTICAL = 1;
    public static final byte PS_FACEDIRECT_HORIZONTAL = 2;
    public byte face_direct = 0;
    public static final byte BLEND_TYPE_ADD = 0;
    public static final byte BLEND_TYPE_REPLACE = 1;
    public static final byte BLEND_TYPE_SUB = 2;
    public static final byte BLEND_TYPE_HALF = 3;
    public byte blend_type = 0;
    public int[] animationList;
    int[] bomb_tx = new int[]{0, 223, 31, 255};
    int bomb_tick = 0;

    public ParticleSystem(String string) {
        this.name = string;
    }

    public boolean isLimited() {
        return this.particleList.size() >= this.limit;
    }

    public void update_bomb() {
        Particle particle;
        int n = 0;
        int n2 = 0;
        if (!this.isLimited()) {
            int n3;
            particle = new Particle();
            particle.degradation = this.attenuation;
            int n4 = n * this.blockWidth;
            int n5 = n2 * this.blockHeight;
            int n6 = n4 + this.blockWidth;
            int n7 = n5 + this.blockHeight;
            particle.size = n3 = Math.abs(this.rand.nextInt() % (this.maxSize - this.minSize + 1)) + this.minSize;
            this.particleList.addElement(particle);
        }
        particle = (Particle)this.particleList.elementAt(0);
        switch (this.bomb_tick) {
            case 0: {
                particle.setTexture(this.bomb_tx[0], this.bomb_tx[1], this.bomb_tx[2], this.bomb_tx[3]);
                break;
            }
            case 1: {
                particle.setTexture(this.bomb_tx[0] + 32, this.bomb_tx[1], this.bomb_tx[2] + 32, this.bomb_tx[3]);
                break;
            }
            case 2: {
                particle.setTexture(this.bomb_tx[0] + 64, this.bomb_tx[1], this.bomb_tx[2] + 64, this.bomb_tx[3]);
                break;
            }
            case 3: {
                particle.setTexture(this.bomb_tx[0] + 96, this.bomb_tx[1], this.bomb_tx[2] + 96, this.bomb_tx[3]);
                break;
            }
            case 4: {
                particle.setTexture(this.bomb_tx[0] + 128, this.bomb_tx[1], this.bomb_tx[2] + 128, this.bomb_tx[3]);
                break;
            }
            case 5: {
                particle.setTexture(this.bomb_tx[0], this.bomb_tx[1], this.bomb_tx[0], this.bomb_tx[1]);
            }
        }
        ++this.bomb_tick;
        if (this.bomb_tick > 5) {
            this.bomb_tick = 5;
        }
    }

    public boolean update() {
        if (!this.visiable || this.finished) {
            return false;
        }
        if (this.createTime > 0) {
            switch (this.type) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    this.update_bomb();
                }
            }
            --this.createTime;
        }
        for (int i = 0; i < this.particleList.size(); ++i) {
            Particle particle = (Particle)this.particleList.elementAt(i);
            particle.update();
            if (!particle.isDead()) continue;
            this.particleList.removeElement(particle);
            particle = null;
        }
        if (++this.time >= this.lastTime && this.lastTime != 0L) {
            this.finished = true;
        }
        return true;
    }

    public void cloneProperty(ParticleSystem particleSystem) {
        particleSystem.time = this.time;
        particleSystem.lastTime = this.lastTime;
        particleSystem.limit = this.limit;
        particleSystem.minSpeed = this.minSpeed;
        particleSystem.maxSpeed = this.maxSpeed;
        particleSystem.x = this.x;
        particleSystem.y = this.y;
        particleSystem.z = this.z;
        particleSystem.minSize = this.minSize;
        particleSystem.maxSize = this.maxSize;
        particleSystem.visiable = this.visiable;
        particleSystem.length = this.length;
        particleSystem.width = this.width;
        particleSystem.height = this.height;
        particleSystem.createNumber = this.createNumber;
        particleSystem.createTime = this.createTime;
        particleSystem.type = this.type;
        particleSystem.attenuation = this.attenuation;
        particleSystem.textureWidth = this.textureWidth;
        particleSystem.textureHeight = this.textureHeight;
        particleSystem.blockWidth = this.blockWidth;
        particleSystem.blockHeight = this.blockHeight;
        particleSystem.animationList = this.animationList;
        particleSystem.face_direct = this.face_direct;
        particleSystem.blend_type = this.blend_type;
    }

    public static void setDefaultEffect_bomb(ParticleSystem particleSystem) {
        particleSystem.type = (byte)8;
        particleSystem.minSize = 100;
        particleSystem.maxSize = 100;
        particleSystem.minSpeed = 0;
        particleSystem.maxSpeed = 0;
        particleSystem.attenuation = -20;
        particleSystem.time = 0L;
        particleSystem.lastTime = 10L;
        particleSystem.createNumber = 1024;
        particleSystem.createTime = 10;
        particleSystem.limit = 1;
        particleSystem.face_direct = (byte)2;
        particleSystem.finished = false;
        particleSystem.visiable = true;
    }
}

